'use strict';

angular.module('genisis').controller('requestHistoryCtrl', ['$scope', 'request',
  '$rootScope', 'api', 'user', '$routeParams', '$location', 'comment',
  function ($scope, $requests, $rootScope, $api, $user, $routeParams,
    $location, $comment) {
    $scope.requests = $requests;
    $scope.commentService = $comment;
    $scope.accessible = !$user.requester();
    $scope.request = {};
    $scope.logs = [];
    $scope.id = $routeParams.id;
    $scope.load = function (requestID) {
      //load the logs for this request
      $requests.logs(requestID, $user.permissions()).then(function (
        logData) {
        $scope.logs = $requests.parseLogs(logData);
      });

      $requests.findByID(requestID).then(function (request) {
        $scope.request = request;
      });
    };

    $scope.backToRequest = function () {
      $location.path('/requests/' + $routeParams.id);
      return true;
    };

    $scope.load($routeParams.id);
  }
]);